@ vim: set ft=armv4 noet:

#define WRAM	0x03000000
#define DISPCNT	0x04000000
#define VRAMBG0	0x06000000
#define LCD_W	240
#define LCD_H	160

#define RGB(r,g,b) (r|(g<<5)|(b<<10))

.arch armv4
.cpu  arm7tdmi

.section .text.crt0,"x"

.arm
.globl _start
_start:
	b rom_hdr_mid@end @ turns out this one *NEEDS* to be a branch >__>

.globl rom_hdr
rom_hdr:
	@!logo
	.fill 156,1,0

.globl logo_end
logo_end:

.arm
.global rom_hdr_mid
rom_hdr_mid:
	add r0, pc, #(.Lpayload-.Lnextins0-4)
.Lnextins0:
	mov r1, #WRAM
	mov r2, #240
	b   .Lrom_hdr_mid2@rom_hdr_end
.thumb

	@ title, game code
	@.fill 16,1,0

	@ maker code
	.byte 0,0

	@!magic
.globl rom_magic
rom_magic:
	.byte 0x96
	@ main unit type
	.byte 0
	@ .byte 0,0x04

.Lrom_hdr_mid2:
.arm
	swi #(0xC*0x10000)
	sub pc, r1, #(0x3C0-0)
.thumb
	@@ device type
	@.byte 0
	@@ reserved
	@.fill 7,1,0

	@ sw version, !checksum
	.byte 0, 0x00

	@ reserved
	.byte 0,0

.arm
.globl mb$_start
mb$_start:
	b rom_hdr_mid@end
.thumb

	@ multiboot stuff: boot method, slave number
	.byte 0 @ set by bios, 0->cart 3->mb
	.byte 0 @ set by bios, 0-3

@@ const stuff needs to be word-aligned, even though it's only a halfword...
@videomode:
@	.short 0x0403

.arm
@.globl rom_hdr_end
@rom_hdr_end:
@	swi #(0xC*0x10000)
@	sub pc, r1, #(0x3C0-0) @ apparently this happens?! @ 0->1 for thumb

.Lpayload:
	@ set video mode
	mov r6, #DISPCNT
	mov r2, #LCD_W
	mov r3, #LCD_H

	ldrh r0, videomode
	strh r0, [r6]
	mov r5, #0

	@ VRAM: r7
	@ DISPCNT: r6
	@ time: r5
	@ tmp: r4
	@ h: r3
	@ w: r2
	@ y: r1
	@ x: r0

.Lframe:
	mov r7, #VRAMBG0
	mov r1, #0

.Lnext_row:
	mov r0, #0

.Lnext_px:

	mov r10, #1
.Lnexttry:

	mul r11, r5, r10
	sub r11, r0
	mul r8, r1, r10
	mul r9, r11, r10
	eor r4, r8, r9
	tst r4, #0x40
	beq .Lcontinue

	ldrh r4, red
	add  r4, r10, lsl #7
	  b  .Lendtry

.Lcontinue:
	add r10, #1
	cmp r10, #16
	bne .Lnexttry
	mov r4 , #0

.Lendtry:
	strh r4, [r7]

	add r0, #1
	add r7, #2
	cmp r0, r2
	blt .Lnext_px

	add r1, #1
	cmp r1, r3
	blt .Lnext_row

	add r5, #1
@.Lwait_vbl:
@	ldrh r4, [r6, #4]
@	tst  r4, #1
@	beq .Lwait_vbl
	b   .Lframe

videomode:
	.short 0x0403
red:
	.short RGB(31,0,0)

.pool

